<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" Inherits="Voxco.Reporting.ProjectSelection" Theme="Voxco"
    Trace="false" Async="true" Title="<%$ Resources:Resource, VoxcoReporting%>" Codebehind="ProjectSelection.aspx.cs" %>

<%@ Register Src="~/WaitingPanel.ascx" TagPrefix="VxRpt" TagName="WaitingPanel" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" Runat="Server">
    
	<telerik:RadScriptBlock ID="ScriptManager" runat="server"> 
	    
		<script type="text/javascript">

		    if (Telerik.Web.UI.RadTreeView != undefined) {
		        Telerik.Web.UI.RadTreeView.prototype.saveClientState = function () {
		            return "{\"expandedNodes\":" + this._expandedNodesJson +
		                ",\"collapsedNodes\":" + this._collapsedNodesJson +
		                ",\"logEntries\":" + this._logEntriesJson +
		                ",\"selectedNodes\":" + this._selectedNodesJson +
		                ",\"checkedNodes\":" + this._checkedNodesJson +
		                ",\"scrollPosition\":" + Math.round(this._scrollPosition) + "}";
		        }
		    }

		    function FindProject(projectId)
			{
				var tree = $find('<%= GroupTreeView.ClientID %>');
				if( tree.get_selectedNode() != null )
				{
					tree.get_selectedNode().unselect();
				}
				var node = tree.findNodeByValue('O:'+projectId.toString());
				if (node != null)
				{		
					var nodeP = node.get_parent();
					
					while(nodeP != null )
					{
						if(nodeP.expand)
						{
							nodeP.expand();
						}
						nodeP = nodeP.get_parent();							
					}
					node.select();
					node.expand();
				}
			}
			
			function btnAddProject_OnClick()
			{
				var _tree = $find('<%= GroupTreeView.ClientID %>');
				var _selectedNodes = _tree.get_selectedNodes();
				if( _selectedNodes != null )
				{				
					var _cmd = "AddProject;";					
					for(var i=0;i<_selectedNodes.length;i++)					
					{
						_cmd +=_selectedNodes[i].get_value() + ":" +_selectedNodes[i].get_text()+ ":" + _selectedNodes[i]._getChildren().get_count() + ";";							
					}		
					$find("<%= MainAjaxPanel.ClientID %>").ajaxRequest(_cmd);															
				}
				return false;
			}
        </script>
	</telerik:RadScriptBlock>
	
    <asp:ObjectDataSource ID="GroupedProjectsDataSource" runat="server" SelectMethod="GetGroupedProjects"
        TypeName="Voxco.Reporting.DataSource.Projects"></asp:ObjectDataSource>
    
    <asp:ObjectDataSource ID="SelectedProjectDataSource" runat="server" SelectMethod="GetGenericSelected" TypeName="Voxco.Reporting.DataSource.Projects">
    </asp:ObjectDataSource>
    
    <telerik:RadAjaxLoadingPanel ID="MainAjaxLoadingPanel" runat="server" Transparency="20">
        <VxRpt:WaitingPanel id="WaitingPanel" runat="server" />
    </telerik:RadAjaxLoadingPanel>
    
    <telerik:RadAjaxPanel ID="MainAjaxPanel" runat="server" EnableAJAX="true" Width="100%" Height="400px" LoadingPanelID="MainAjaxLoadingPanel" OnAjaxRequest="MainAjaxPanel_OnAjaxRequest">
    <br />
        <div style="float: left; width: 20%; height: 400px; overflow: auto; border: 1px solid #828282;">
        
			<telerik:RadTreeView 
				ID="GroupTreeView" 
				runat="server" 
				MultipleSelect="true"
				DataFieldID="NodeId" 
				DataFieldParentID="ParentNodeId" 
				DataTextField="NodeLabel" 
				DataValueField="NodeId" 
				LoadingMessage="..."
				OnNodeExpand="GroupTreeView_NodeExpand"
				OnDataBound="GroupTreeView_DataBound" 
				OnNodeDataBound="GroupTreeView_NodeBound">
            </telerik:RadTreeView>
            
		</div>
		        
        <div style="float: left; width: 25px; height: 100%;">
			<div class="arrows">
				<asp:ImageButton ID="btnAddProject" runat="server" ImageUrl="~/icons/arrow_right_blue.png" OnClientClick="javascript: return btnAddProject_OnClick();" />
				<asp:ImageButton ID="btnRemoveProject" runat="server" ImageUrl="~/icons/arrow_left_blue.png" OnClick="btnRemoveProject_OnClick" />
			</div>
		</div>
         
        <div style="float: left; width: 75%;">			

			<telerik:RadGrid ID="grdSelectedProjects" runat="server" AllowSorting="true" 
			DataSourceID="SelectedProjectDataSource" AllowMultiRowSelection="True" AutoGenerateColumns="False" 
			OnDataBound="grdSelectedProjects_OnDataBound" height="400px" Width="100%"
			EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
                <ClientSettings>
                    <Selecting AllowRowSelect="True" />
                    <Scrolling AllowScroll="True" UseStaticHeaders="True" />
                </ClientSettings>
                    
                <MasterTableView NoMasterRecordsText="" Width="100%">
					<SortExpressions>
						<telerik:GridSortExpression FieldName="Name" />
					</SortExpressions>                            
                    <Columns>
						<telerik:GridBoundColumn DataField="Id" DataType="System.Int32" Display="False" HeaderText="Id" UniqueName="Id">
						</telerik:GridBoundColumn>
						<telerik:GridClientSelectColumn DataType="System.Boolean" UniqueName="Selected">
							<HeaderStyle Width="10%" HorizontalAlign="Left"/>
							<ItemStyle Width="10%" HorizontalAlign="Left" />
						</telerik:GridClientSelectColumn>
						<telerik:GridBoundColumn DataField="Name" HeaderText="<%$ Resources:Resource, SelectedProjects %>" UniqueName="Name">
							<HeaderStyle Width="30%" HorizontalAlign="left" />
							<ItemStyle Width="30%" />
						</telerik:GridBoundColumn>
						<telerik:GridBoundColumn DataField="FullPath" HeaderText="<%$ Resources:Resource, Path %>" UniqueName="FullPath">
							<HeaderStyle Width="50%" HorizontalAlign="left" />
							<ItemStyle Width="50%" />
						</telerik:GridBoundColumn>
						<telerik:GridHyperLinkColumn Text="<%$ Resources:Resource, Find %>" UniqueName="Find" DataNavigateUrlFields="FindProjectUrl" HeaderImageUrl="~/icons/ico16_find.gif">
							<HeaderStyle Width="10%" HorizontalAlign="Center" />
							<ItemStyle Width="10%" HorizontalAlign="Center" />
						</telerik:GridHyperLinkColumn>
                    </Columns>                            
                </MasterTableView>
            </telerik:RadGrid>
                
		</div>

	</telerik:RadAjaxPanel>

</asp:Content>


